import pika
import json
import websocket
import base64
from datetime import datetime
import sys
import logging_rpi
import BackhaulConfiguration
from Backhaul import Backhaul
import os

class BackhaulSubscribe(object):
    def __init__(self, **kwargs):
        
        # Settings available
        self.queueName = kwargs.get("queueName", "readerQueue")
        self.serial = BackhaulConfiguration.getSerial()
        self.backhaul = kwargs.get("queueName", Backhaul("publicQueue"))
        self.topic = kwargs.get("topic", None)
        self.publish = kwargs.get("publish", True)
        print("Listening to: " + str(self.topic))
        self.fullTopicName = None

        # Callback Variables, no use if used here
        self.getOne = False
        self.result = None
        self.override = False

        #Update variables 
        self.updateInterval = BackhaulConfiguration.getUpdateInterval()
        self.restartInterval = BackhaulConfiguration.getRestartInterval()
        self.lastUpdated = datetime.now()

    def updateListenerPulsarAddress(self):

        # First: update Pulsar address in the conf file
        try:
            updateStatus = BackhaulConfiguration.updatePulsarAddress()
            if not updateStatus:
                logging_rpi.log.error("SocketWorkerCB Module:::Server Address not Updated:::Possible Timeout. SocketWorkerCB will use previous address if available.")
        except Exception as e:
            logging_rpi.log.error("SocketWorkerCB Module:::Server Address not Updated:::" + str(e))
            logging_rpi.log.warn("SocketWorkerCB Module:::Server Address not Updated:::Failed. Using old Pulsar Address if exist")

        # Second: get the address from the config file
        # If it is not updated, then try getting a previous one if got

        address = BackhaulConfiguration.getPulsarAddress()
        if address is not None:
            print(address + "/ws/v2/consumer/persistent/public/default/" + self.topic + "/my-subscription?subscriptionType=Exclusive")
            return address + "/ws/v2/consumer/persistent/public/default/" + self.topic + "/my-subscription?subscriptionType=Exclusive"
        else:
            # see if baseTopic got previous data or not
            if self.fullTopicName is not None:
                logging_rpi.log.warn("SocketWorkerCB Module:::Server Address not Updated:::Failed. Using old Pulsar Address if exist")
                return self.fullTopicName
            else:
                logging_rpi.log.info("SocketWorkerCB Module:::Server Address not Updated:::No valid pulsar address. Sleeping for seconds: " + str(self.restartInterval))
                time.sleep(self.restartInterval)
                return self.updateBaseTopic()

    def listenPulsar(self, **kwargs):

        #override pulsar's main function to do an operation when data is gotten
        #if getOne is True, do it once once. Otherwise, continue indefinitely
        self.getOne = kwargs.get('getOne', False)
        self.override = kwargs.get('override', False)

        if self.topic is None:
            logging_rpi.log.error("BackhaulSubscribe:::Read Topic Error:::No topic name provided")
            return False

        self.fullTopicName = self.updateListenerPulsarAddress()
        sub_ws = websocket.create_connection(self.fullTopicName)
        sub_ws.settimeout(45)

        while True:

            # Update Backhaul 
            currentTime = datetime.now()
            difference =  (currentTime - self.lastUpdated).seconds
            if difference >= self.updateInterval:
                print("Interval hit. Updating configuration...")
                self.lastUpdated = currentTime
                self.updateInterval = BackhaulConfiguration.getUpdateInterval()
                self.fullTopicName = self.updateListenerPulsarAddress()
                print("BackhaulSubsribe::Update Interval is now: " + str(self.updateInterval))
                logging_rpi.log.info("SocketWorkerCB Module:::Server Address Updated:::Now Listening to: "+str(self.fullTopicName))
                BackhaulConfiguration.writeBackup()
                BackhaulConfiguration.logProcess(os.getpid())

            try:
                print '[x] Ready for messages...'
                self.data = None
                msg = sub_ws.recv()
                if not msg:
                    print "Pulsar had no messages -- reconnecting safely."
                    sub_ws.close()
                    sub_ws = websocket.create_connection(self.fullTopicName)
                    continue

                msg = json.loads(msg)
                data = json.loads(base64.b64decode(msg['payload']))
                sub_ws.send(json.dumps({'messageId': msg['messageId']}))

                if self.override:
                    self.data = data
                    self.pulsarMain() # Override this in the child classes
                if self.getOne:
                    return self.data
                continue
                
            except websocket.WebSocketConnectionClosedException as e:
                print "Socket Closed. Reconnecting..."
                sub_ws.close()
                sub_ws = websocket.create_connection(self.fullTopicName)
                continue
            except Exception as e:
                if str(e) == "timed out":
                    sub_ws.close()
                    sub_ws = websocket.create_connection(self.fullTopicName)
                    continue
                logging_rpi.log.error("BackhaulSubscribe:::Read Topic Error:::" + str(e))
                continue

    def listenRabbitMQ(self, **kwargs):

        self.getOne = kwargs.get('getOne', False)

        self.connection = pika.BlockingConnection(pika.ConnectionParameters(host='localhost'))
        self.channel = self.connection.channel()

        self.channel.queue_declare(queue=self.queueName, durable=True)
        print(' [*] Waiting for messages. To exit press CTRL+C')

        self.channel.basic_qos(prefetch_count=1)
        self.channel.basic_consume(queue=self.queueName, on_message_callback=self.readerCallBack)

        self.channel.start_consuming()

    def readerCallBack(self, channel, method_frame, header_frame, body):

        body = body.encode('utf-8')
        data = json.loads(body)

        try:

            if (self.topic is not None and self.topic == data['Topic']) or self.topic is None:
                print "=========================================="
                print data

            if self.getOne:
                channel.basic_reject(delivery_tag=method_frame.delivery_tag, requeue=False)
                self.result = body
                self.channel.stop_consuming()

        except Exception as e:

            print "Unable to read the requested module: "
            logging_rpi.log.error("BackSubscribe:::Read Specific Module Error:::" + str(e))

        if self.publish:
            print "Publish Status: ",
            print self.backhaul.send(data)
            
        channel.basic_reject(delivery_tag=method_frame.delivery_tag, requeue=False)

    def pulsarMain(self):
        print "Override this main function for Pulsar."
        print "Instruct main function to do things with self.data"

if __name__ == '__main__':
    reader = BackhaulSubscribe(topic="reddit", publish=False)
    reader.updateListenerPulsarAddress()   
    reader.fullTopicName